<?php

namespace Drupal\activetickets_client\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Settings form for ActiveTickets.
 */
class ActiveTicketsSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return [
      'activetickets_client.settings',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'activetickets_client';
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $settings = $this->config('activetickets_client.settings');

    $form['wsdl_settings'] = [
      '#type' => 'fieldset',
      '#attributes' => [
        'id' => 'wsdl-settings',
      ],
    ];

    $form['wsdl_settings']['wsdl_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('WSDL Url'),
      '#default_value' => $settings->get('wsdl_url') ?? '',
    ];

    $form['wsdl_settings']['wsdl_member_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('WSDL member Url'),
      '#default_value' => $settings->get('wsdl_member_url') ?? '',
    ];

    $form['client_settings'] = [
      '#type' => 'fieldset',
      '#attributes' => [
        'id' => 'client-settings',
      ],
    ];

    $form['client_settings']['client_name'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Client name'),
      '#default_value' => $settings->get('client_name'),
    ];

    $form['client_settings']['langcode'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Language code'),
      '#default_value' => $settings->get('langcode'),
    ];

    $form['client_settings']['ticket_url'] = [
      '#type' => 'textfield',
      '#title' => $this->t('Ticket Url'),
      '#default_value' => $settings->get('ticket_url'),
    ];

    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {

    foreach ($form_state->getValues() as $key => $item) {
      $this->config('activetickets_client.settings')
        ->set($key, $item)
        ->save();
    }
    parent::submitForm($form, $form_state);
  }

}
