<?php

declare(strict_types=1);

namespace Drupal\Tests\activetickets_client\Unit;

use Drupal\activetickets_client\Client\ActiveTicketsClient;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;
use Drupal\Core\Logger\LoggerChannelInterface;
use Drupal\Tests\UnitTestCase;

/**
 * Tests ActiveTickets service.
 *
 * @coversDefaultClass \Drupal\activetickets_client\Client\ActiveTicketsClient
 * @ingroup activetickets
 */
class ActiveTicketsClientTest extends UnitTestCase {

  /**
   * ActiveTickets client.
   *
   * @var \Drupal\activetickets_client\Client\ActiveTicketsClient
   */
  protected ActiveTicketsClient $activeTickets;

  /**
   * {@inheritDoc}
   */
  public function setUp(): void {
    parent::setUp();

    $loggerProphecy = $this->prophesize(LoggerChannelFactoryInterface::class);
    $loggerProphecy->get('activetickets_client')->willReturn($this->prophesize(LoggerChannelInterface::class));

    $configFactoryProphecy = $this->getConfigFactoryStub([
      'activetickets_client.settings' => [
        'wsdl_url' => 'http://webservices.activetickets.com/ActiveTicketsServices.asmx?wsdl',
        'wsdl_member_url' => 'http://webservices.activetickets.com/members/ActiveTicketsMembersServices.asmx?wsdl',
        'ticket_url' => 'https://tickets.example.com',
        'client_name' => 'ActiveTicketsCLientName',
        'langcode' => 'EN',
      ],
    ]);

    $this->activeTickets = new ActiveTicketsClient(
      $loggerProphecy->reveal(),
      $configFactoryProphecy,
      FALSE
    );
  }

  /**
   * Test getRequestParams function.
   *
   * @dataProvider providerTestRequestParams
   * @covers ::getRequestParams
   */
  public function testRequestParams(array $data, $expected) {
    $this->assertSame($expected, $this->activeTickets->getRequestParams());
  }

  /**
   * Data provider for testRequestParams().
   *
   * @return array[]
   *   Data set.
   */
  public function providerTestRequestParams() {
    return [
      0 => [
        'data' => [],
        'expected' => [
          'Clientname' => 'ActiveTicketsCLientName',
          'LanguageCode' => 'EN',
        ],
      ],
    ];
  }

}
