<?php

namespace Drupal\acumatica\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;
use Drupal\Core\Entity\EntityDescriptionInterface;

/**
 * Defines the interface for Acumatica connection types.
 *
 * Connection type configuration entities hold all information needed by session
 * managers for establishing connections to Acumatica instances. A connection
 * content entity could be added to track individual connections if needed, such
 * as for auditing or troubleshooting purposes.
 */
interface ConnectionTypeInterface extends
  ConfigEntityInterface,
  EntityDescriptionInterface {

  /**
   * Returns the ID of the web service endpoint e.g. Default or eCommerce.
   *
   * @return string|null
   *   The ID, or NULL if it has not been defined.
   */
  public function getApiId(): ?string;

  /**
   * Returns the version of the web service endpoint e.g. 22.200.001.
   *
   * @return string|null
   *   The version, or NULL if it has not been defined.
   */
  public function getApiVersion(): ?string;

  /**
   * Returns the base namespace of the API client.
   *
   * This is the base namespace where the client generated by the OpenAPI
   * generator are placed. For example, if the full namespace of the class used
   * for accessing the stock item resource is
   * `Drupal\my_module\Acumatica\Api\Client\eCommerce\22.200.001\Api\StockItem`,
   * the base namespace would be `Drupal\my_module\Acumatica\Api\Client`.
   *
   * @return string|null
   *   The namespace, or NULL if it has not been defined.
   */
  public function getBaseNamespace(): ?string;

  /**
   * Returns the authentication settings.
   *
   * These depend on the authentication mechanism used by the session manager
   * that establishes the connection.
   *
   * @return array|null
   *   The authentication settings, or NULL if no settings have been defined.
   */
  public function getAuthentication(): ?array;

}
