(function (document, $, Drupal, once) {
  Drupal.behaviors.ad = {
    attach(context, settings) {
      const query = { ads: {} };

      $(once('ad-content', 'ad-content', context)).each(function () {
        const $placeholder = $(this);
        query.ads[$placeholder.attr('id')] = {
          placement: $placeholder.attr('placement'),
          bucket: $placeholder.attr('bucket'),
          arguments: $placeholder.attr('arguments') || {},
        };
      });

      if (Object.keys(query.ads).length > 0) {
        query.uid = settings.user.uid;
        query.url = document.URL;
        query.page_title = document.title;
        query.referrer = document.referrer;

        const url = Drupal.url('ad/content/render');
        $.get(
          url,
          query,
          function (responseData) {
            Object.keys(responseData).forEach((id) => {
              if (responseData.hasOwnProperty(id)) {
                $(`#${id}`).html(responseData[id]);
              }
            });
          },
          'json',
        );
      }
    },
  };
})(document, jQuery, Drupal, once);
