<?php

namespace Drupal\ad_content_scheduler\Plugin\Scheduler;

use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\scheduler\SchedulerPluginBase;

/**
 * Advertisement plugin for the scheduler module.
 *
 * @SchedulerPlugin(
 *  id = "ad_content_scheduler",
 *  label = @Translation("Advertisement scheduler plugin"),
 *  description = @Translation("Support for scheduling advertisement entities"),
 *  entityType = "ad_content",
 *  dependency = "ad_content",
 *  schedulerEventClass = "\Drupal\ad_content_scheduler\Event\SchedulerAdContentEvents",
 *  publishAction = "ad_content_scheduler_publish_ad_content",
 *  unpublishAction = "ad_content_scheduler_unpublish_ad_content"
 * )
 */
class AdContentScheduler extends SchedulerPluginBase implements ContainerFactoryPluginInterface {}
