<?php

namespace Drupal\ad;

use Drupal\Core\Url;

/**
 * Common interface for ad domain objects.
 */
interface AdInterface {

  /**
   * Returns the ad identifier.
   *
   * @return string
   *   An string uniquely identifying the ad.
   */
  public function getAdIdentifier(): string;

  /**
   * Returns the ID of the bucket providing the ad.
   *
   * @return string
   *   A bucket machine name.
   */
  public function getBucketId(): string;

  /**
   * Returns the ad placement ID.
   *
   * @return string
   *   The ad placement ID.
   */
  public function getPlacementId(): string;

  /**
   * Returns the target URL.
   *
   * @return \Drupal\Core\Url|null
   *   A URL object or NULL if none is defined.
   */
  public function getTargetUrl(): ?Url;

}
