<?php

namespace Drupal\ad\Entity;

/**
 * The ad placement factory.
 */
interface AdPlacementManagerInterface {

  /**
   * Returns the specified ad placement.
   *
   * @param string $id
   *   The ad placement machine name.
   *
   * @return AdPlacementInterface|null
   *   An ad placement or NULL if the requested ad placement does not exist.
   */
  public function get(string $id): ?AdPlacementInterface;

  /**
   * Returns all available ad placements.
   *
   * @return AdPlacementInterface[]
   *   An array of ad placements.
   */
  public function getAll(): array;

  /**
   * Returns an array of all available ad placements.
   *
   * @return array
   *   An array of all available ad placement names keyed by their ID.
   */
  public function getList(): array;

}
