<?php

namespace Drupal\ad_content_scheduler\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Unpublishes an ad content.
 *
 * @Action(
 *   id = "ad_content_scheduler_unpublish_ad_content",
 *   label = @Translation("Unpublish selected advertisements"),
 *   type = "ad_content"
 * )
 */
class UnpublishAdContent extends ActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    /** @var \Drupal\ad_content\Entity\AdContentInterface $entity */
    $entity->setUnpublished();
    $entity->save();
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    /** @var \Drupal\ad_content\Entity\AdContentInterface $entity */
    $result = $object
      ->access('update', $account, TRUE)
      ->andIf($object->status->access('edit', $account, TRUE));

    return $return_as_object ? $result : $result->isAllowed();
  }

}
