<?php

namespace Drupal\ad\Track;

use Drupal\Core\Utility\Error;
use Drupal\ad\AdFactoryBase;
use Drupal\ad\Plugin\Ad\Track\NullTracker;
use Drupal\Component\Plugin\Exception\PluginException;
use Drupal\Core\Logger\LoggerChannelFactory;
use Psr\Log\LoggerInterface;

/**
 * The ad tracker factory.
 *
 * @internal
 */
class TrackerFactory extends AdFactoryBase implements TrackerFactoryInterface {

  /**
   * The logger service.
   *
   * @var \Psr\Log\LoggerInterface
   */
  protected LoggerInterface $logger;

  /**
   * TrackerFactory constructor.
   *
   * @param \Drupal\ad\Track\TrackerPluginManager $plugin_manager
   *   The ad tracker plugin manager.
   * @param \Drupal\Core\Logger\LoggerChannelFactory $loggerFactory
   *   The logger factory service.
   */
  public function __construct(TrackerPluginManager $plugin_manager, LoggerChannelFactory $loggerFactory) {
    $this->pluginManager = $plugin_manager;
    $this->logger = $loggerFactory->get('ad_content');
  }

  /**
   * {@inheritdoc}
   */
  public function get(string $name): TrackerInterface {
    try {
      /** @var \Drupal\ad\Track\TrackerInterface $tracker */
      $tracker = $this->pluginManager->createInstance($name);
      return $tracker;
    }
    catch (PluginException $e) {
      Error::logException($this->logger, $e);
    }
    return $this->get(NullTracker::TRACKER_ID);
  }

  /**
   * {@inheritdoc}
   */
  public function getList(): array {
    $list = parent::getList();
    $list = array_intersect_key($list, [NullTracker::TRACKER_ID => TRUE]) + $list;
    return $list;
  }

}
