(function (document, Drupal, once) {
  Drupal.behaviors.ad = {
    attach(context, settings) {
      const query = { ads: {} };

      const elements = once('ad-content', 'ad-content', context);
      elements.forEach(function (element) {
        const id = element.getAttribute('id');
        query.ads[id] = {
          placement: element.getAttribute('placement'),
          bucket: element.getAttribute('bucket'),
          arguments: element.getAttribute('arguments') || {},
        };
      });

      if (Object.keys(query.ads).length > 0) {
        query.uid = settings.user.uid;
        query.url = document.URL;
        query.page_title = document.title;
        query.referrer = document.referrer;
        fetch(Drupal.url('ad/content/render'), {
          method: 'GET',
          headers: {
            'Content-Type': 'application/json',
          },
          body: JSON.stringify(query),
        })
          .then((response) => response.json())
          .then((responseData) => {
            Object.keys(responseData).forEach((id) => {
              if (responseData.hasOwnProperty(id)) {
                const el = document.getElementById(id);
                if (el) {
                  el.innerHTML = responseData[id];
                }
              }
            });
          })
          .catch((error) => {
            console.error('Error fetching ad content:', error);
          });
      }
    },
  };
})(document, Drupal, once);
