<?php

namespace Drupal\ad_content\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Common interface for advertisement type bundle entities.
 */
interface AdContentTypeInterface extends ConfigEntityInterface {

  /**
   * Returns the description of the advertisement type.
   *
   * @return string
   *   The description of the advertisement type.
   */
  public function getDescription(): string;

  /**
   * Sets the description of the advertisement type.
   *
   * @param string $description
   *   The description of the advertisement type.
   */
  public function setDescription($description);

}
