<?php

namespace Drupal\ad_content_scheduler\Plugin\Action;

use Drupal\Core\Action\ActionBase;
use Drupal\Core\Session\AccountInterface;

/**
 * Publishes an ad content.
 *
 * @Action(
 *   id = "ad_content_scheduler_publish_ad_content",
 *   label = @Translation("Publish selected advertisements"),
 *   type = "ad_content"
 * )
 */
class PublishAdContent extends ActionBase {

  /**
   * {@inheritdoc}
   */
  public function execute($entity = NULL) {
    /** @var \Drupal\ad_content\Entity\AdContentInterface $entity */
    $entity->setPublished(TRUE);
    $entity->save();
  }

  /**
   * {@inheritdoc}
   */
  public function access($object, ?AccountInterface $account = NULL, $return_as_object = FALSE) {
    /** @var \Drupal\ad_content\Entity\AdContentInterface $entity */
    $result = $object
      ->access('update', $account, TRUE)
      ->andIf($object->status->access('edit', $account, TRUE));

    return $return_as_object ? $result : $result->isAllowed();
  }

}
