<?php

namespace Drupal\ad\Bucket;

use Drupal\ad\AdFactoryInterface;

/**
 * Common interface for ad bucket factories.
 */
interface BucketFactoryInterface extends AdFactoryInterface {

  /**
   * Returns the specified ad bucket.
   *
   * @param string $id
   *   The bucket machine name.
   *
   * @return \Drupal\ad\Bucket\BucketInterface
   *   An ad bucket instance.
   */
  public function get(string $id): BucketInterface;

}
