<?php

declare(strict_types=1);

namespace Drupal\ad\Entity;

use Drupal\Core\Config\Entity\ConfigEntityInterface;

/**
 * Provides an interface defining an ad placement entity type.
 */
interface AdPlacementInterface extends ConfigEntityInterface {

  /**
   * Returns the description of the ad placement type.
   *
   * @return string
   *   The description of the ad placement type.
   */
  public function getDescription(): string;

  /**
   * Sets the description of the ad placement type.
   *
   * @param string $description
   *   The description of the ad placement type.
   */
  public function setDescription($description);

}
