# Advertisement

The Advertisement module provides a flexible and extensible advertising system
allowing to display ads via the block layout.

The advertisement system is built dynamically so that both content providers
(called "advertisement buckets") and statistics trackers can be extended by
custom modules via the plugin API. A native provider and tracker are also
provided as submodules, as well as a native integration for the
[Scheduler](https://www.drupal.org/project/scheduler) module.

The native tracker module implements two trackers:
- The *"Local advertisement event tracker"* tracks impressions/clicks
immediately, which on high traffic sites can result in significant additional
load for the web servers.
- The *"Queue-based local advertisement event tracker"* tracks data via a queue,
so events will only actually appear in the statistics display section after
running cron or after manually processing `ad_track_queue`.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/ad).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/ad).


## Requirements

This module requires the following modules:

- [**Scheduler**](https://www.drupal.org/project/scheduler) - Optionally
required when using the *"Advertisement content scheduler"* submodule.


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

After the installation, you need to install an advertisement content provider
(e.g., the *"Advertisement content"* submodule) in order for the system to work.

If you install the native *"Advertisement track"* tracker module, the tracker
will work out of the box. In case you want to install a custom statistics
tracker, perform the following steps to enable it:

1. Go to *Configuration » Content authoring » Advertisement settings*.
1. Select the tracker that you want to use for each advertisement content
provider that you installed (the native tracker module will enable itself
automatically here).

After that, you can place one or more advertisement blocks in your block layout,
which will then display the randomly chosen ads. *In order for ads to be shown
in a block, their selected size must match that of the block!*

You can also create / manage different "advertisement placements" which serve
as a simple way to differentiate groups of ads (e.g., by size, company, topic,
etc.) at *Configuration » Content authoring » Advertisement placements*. You can
then choose what placements to display for each advertisement block in the block
layout.

Finally, if you are using the *"Advertisement content"* submodule, you can
create and manage your advertisements at *Content » Advertisements*
(Add an advertisement at `/admin/content/ad/add`), as well as the advertisement
types (bundles) at *Structure » Advertisement types*.

There are also granular permissions available at *People » Permissions* that
allow you to configure who ads are shown to on your site, as well as who is able
to view, edit and delete them and their revisions in the admin UI.
