<?php

namespace Drupal\ad_content\Entity;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Advertisement list builder.
 */
class AdContentTypeListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   */
  public function buildHeader() {
    $header = [
      'title' => $this->t('Title'),
      'description' => $this->t('Description'),
    ];

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   */
  public function buildRow(EntityInterface $ad_content_type) {
    /** @var \Drupal\ad_content\Entity\AdContentTypeInterface $ad_content_type */

    $row = [
      'title' => $ad_content_type->label(),
      'description' => $ad_content_type->getDescription(),
    ];

    return $row + parent::buildRow($ad_content_type);
  }

}
