<?php

namespace Drupal\Tests\ad_track\Functional;

use Drupal\ad_content\Entity\AdContent;
use Drupal\ad_content\Entity\AdContentType;
use Drupal\ad\Entity\AdPlacement;
use Drupal\ad_track\Entity\AdTrackEvent;
use Drupal\Tests\BrowserTestBase;

/**
 * Tests the AdTrack functionality.
 *
 * @group ad_track
 */
class AdTrackTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['ad', 'ad_content', 'ad_track'];

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * A user with permission to administer ads.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * A test ad content type.
   *
   * @var \Drupal\ad_content\Entity\AdContentType
   */
  protected $adContentType;

  /**
   * A test ad placement.
   *
   * @var \Drupal\ad\Entity\AdPlacement
   */
  protected $placement;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();

    $this->adminUser = $this->drupalCreateUser([
      'administer ads',
      'view ads',
    ]);

    // Create a test placement.
    $this->placement = AdPlacement::create([
      'id' => 'test_placement',
      'label' => 'Test Placement',
      'description' => 'Test description',
    ]);
    $this->placement->save();

    // Create a test ad content type.
    $this->adContentType = AdContentType::create([
      'id' => 'test_type',
      'label' => 'Test Type',
    ]);
    $this->adContentType->save();
  }

  /**
   * Tests tracking clicks.
   */
  public function testTrackClick() {
    // Create an ad.
    $ad = AdContent::create([
      'bundle' => 'test_type',
      'title' => 'Test Ad',
      'placement' => 'test_placement',
      'target_url' => ['uri' => 'https://example.com'],
      'status' => TRUE,
    ]);
    $ad->save();

    // Simulate a click by creating an event.
    $event = AdTrackEvent::create([
      'type' => 'click',
      'ad_id' => $ad->id(),
    ]);
    $event->save();

    // Verify the event exists.
    $events = \Drupal::entityTypeManager()
      ->getStorage('ad_track_event')
      ->loadByProperties([
        'ad_id' => $ad->id(),
        'type' => 'click',
      ]);
    $this->assertNotEmpty($events);
  }

}
