<?php

namespace Drupal\ad\Bucket;

use Drupal\ad\AdInterface;
use Drupal\ad\Track\TrackerInterface;

/**
 * Common interface for ad buckets.
 */
interface BucketInterface {

  /**
   * Builds an ad placeholder with the specified placement.
   *
   * @param string $placement_id
   *   The ID of the ad placement.
   *
   * @return array
   *   A renderable ad placeholder array.
   */
  public function buildPlaceholder(string $placement_id): array;

  /**
   * Builds an ad with the specified placement.
   *
   * @param string $placement_id
   *   The ID of the ad placement.
   *
   * @return array
   *   An ad render array.
   */
  public function buildAd(string $placement_id): array;

  /**
   * Returns the specified ad.
   *
   * @param string $id
   *   The ad identifier.
   *
   * @return \Drupal\ad\AdInterface|null
   *   An ad instance or NULL if none could be found.
   */
  public function getAd(string $id): ?AdInterface;

  /**
   * Returns the bucket's ad tracker.
   *
   * @return \Drupal\ad\Track\TrackerInterface
   *   A tracker instance.
   */
  public function getTracker(): TrackerInterface;

  /**
   * Returns whether the bucket doesn't contain ads of the specified placement.
   *
   * @param string $placement_id
   *   The ID of the ad placement to check for.
   *
   * @return bool
   *   Whether or not the bucket is empty.
   */
  public function isEmpty(string $placement_id): bool;

  /**
   * Returns the amount of ads in the bucket that have the specified placement.
   *
   * @param string $placement_id
   *   The ID of the ad placement to check for.
   *
   * @return int
   *   The amount of ads in the bucket that have the placement.
   */
  public function getPlacementCount(string $placement_id): int;

}
