<?php

namespace Drupal\ad\Entity;

use Drupal\Core\Entity\EntityTypeManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * The ad placement factory.
 */
class AdPlacementManager implements AdPlacementManagerInterface {

  /**
   * The entity type manager.
   *
   * @var \Drupal\Core\Entity\EntityTypeManagerInterface
   */
  protected $entityTypeManager;

  public function __construct(EntityTypeManagerInterface $entityTypeManager) {
    $this->entityTypeManager = $entityTypeManager;
  }

  /**
   * Creates a new instance of the ad placement factory.
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('entity_type.manager')
    );
  }

  /**
   * {@inheritDoc}
   */
  public function get(string $id): ?AdPlacementInterface {
    return $this->entityTypeManager->getStorage('ad_placement')->load($id);
  }

  /**
   * {@inheritDoc}
   */
  public function getAll(): array {
    return $this->entityTypeManager->getStorage('ad_placement')->loadMultiple();
  }

  /**
   * {@inheritDoc}
   */
  public function getList(): array {
    $placements = $this->getAll();
    $list = [];
    foreach ($placements as $placement) {
      $list[$placement->id()] = $placement->label();
    }
    return $list;
  }

}
