<?php

namespace Drupal\ad\Form;

use Drupal\ad\Bucket\BucketFactoryInterface;
use Drupal\Core\Entity\EntityDeleteForm;
use Drupal\Core\Form\FormStateInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Custom ad placement delete form.
 *
 * @internal
 */
class AdPlacementDeleteForm extends EntityDeleteForm {

  /**
   * The ad bucket factory.
   *
   * @var \Drupal\ad\Bucket\BucketFactoryInterface
   */
  protected $bucketFactory;

  /**
   * {@inheritdoc}
   */
  public function __construct(
    BucketFactoryInterface $bucketFactory,
  ) {
    $this->bucketFactory = $bucketFactory;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container) {
    return new static(
      $container->get('ad.bucket_factory')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $adsAmount = 0;

    $bucketIds = array_keys($this->bucketFactory->getList());
    foreach ($bucketIds as $bucketId) {
      $bucket = $this->bucketFactory->get($bucketId);
      $adsAmount += $bucket->getPlacementCount($this->entity->id());
    }

    if ($adsAmount > 0) {
      $caption = '<p>' . $this->formatPlural($adsAmount,
        'The placement %placement is used by 1 advertisement on your site. You can not remove this placement type until you have removed that advertisement.',
        'The placement %placement is used by @count advertisements on your site. You can not remove this placement type until you have removed all corresponding advertisements.',
        [
          '%placement' => $this->entity->label(),
        ]) . '</p>';
      $form['#title'] = $this->getQuestion();
      $form['description'] = ['#markup' => $caption];
      return $form;
    }

    return parent::buildForm($form, $form_state);
  }

}
