<?php

namespace Drupal\ad\Track;

use Drupal\ad\AdFactoryInterface;

/**
 * Common interface for ad tracker factories.
 */
interface TrackerFactoryInterface extends AdFactoryInterface {

  /**
   * Returns the specified ad tracker.
   *
   * @param string $name
   *   The tracker machine name.
   *
   * @return \Drupal\ad\Track\TrackerInterface
   *   An ad tracker instance.
   */
  public function get(string $name): TrackerInterface;

}
