# Adaptive Interact Client

**Adaptive Interact Client** is a custom Drupal module that provides a reusable block and render element to embed an 'Adaptive Interactive' widget.

## Features

- Provides a **configurable block** (`InteractWidgetBlock`) to display an interactive widget.
- Admin form (`SettingsForm`) to store and manage widget configuration.
- Exposes a **custom render element**: `adaptive_interact_client__widget`.
- Uses a Twig template to output the widget markup and attach the required JS/CSS via a Drupal library.

## Installation

1. Place the `adaptive_interact_client` module in your Drupal site's `modules/custom` directory.
2. Enable the module via the **Extend** menu or with Drush:

   ```bash
   drush en adaptive_interact_client
   ```

## Configuration

1. Go to **Configuration > System > Adaptive Interact Settings**.
2. Input the 'Server URL', 'Default widget ID' and optionally select a user field that can be used as an avatar.
3. Save the settings.

## Usage

### 1. As a Block

Place the **Adaptive Interact Widget** block via **Structure > Block Layout**.
It renders a `<div>` like the following and automatically attaches the necessary JS/CSS library:

```html
<div class="adaptive-interact-widget" data-aiw-id="[widget-id]" data-aiw="[config-data]"></div>
```

### 2. As a Render Element (Programmatically)

In custom module code use the following render array. '#data' should be a JSON formatted string and can contain any of the following:

`prompt`: One or more prompts to send. Multiple prompts will be rendered as bubbles for a user to choose from.

`avatarUrl`: The URL of the current user's profile image.

`buttonType`: The type of button used to launch the modal. Can be 'Text', 'Icon' or 'Text & icon' *

`buttonText`: The text to appear in the button if applicable *

* By default a button will be automatically rendered from the server side. If you want to use your own button place it within the `adaptive-interact-widget` container and give it a class of `aiw-modal--button--open`. If you do this there is no need for `buttonType` or `buttonText`

```php
[
  '#type' => 'adaptive_interact_client__widget',
  '#id' => '123456789', // Replace with your widget ID
  '#data' => '{prompt: "Tell me about..."}',
]
```

This:

- Attaches the `adaptive_interact_client/widget` library
- Renders the widget via the Twig template

### 3. Manually in Templates

You can include the widget manually in any Twig template (e.g., node.html.twig, page.html.twig):

```twig
{{ attach_library('adaptive_interact_client/widget') }}
<div class="adaptive-interact-widget" data-aiw-id="[widget-id]" data-aiw="[config-data]"></div>
```

Replace `"[widget-id]"` with the widget ID.
Replace `"[config-data]"` with the JSON needed for your widget configuration.

> 💡 Tip: Use this method if you want precise control over placement and don’t need dynamic configuration from the admin UI.

## Template

The module uses the Twig template:

`adaptive-interact-client--widget.html.twig`

You may override this in your theme to customize the output.

## Dependencies

- Drupal 9.x or 10.x
- No external module dependencies
