/**
 * @file
 * Address autocomplete behavior.
 */

(function ($, Drupal, once) {

  Drupal.behaviors.addressAutocompletePhoton = {
    attach(context, settings) {
      const addressAutocompleteSettings = settings.addressAutocomplete || {};

      // Define custom autocomplete settings.
      const autocompleteSettings = {
        allowOverrides: addressAutocompleteSettings.allow_overrides,
        defaultCountry: addressAutocompleteSettings.default_country,
        format: addressAutocompleteSettings.format,
        limit: parseInt(addressAutocompleteSettings.limit, 10),
        minLength: parseInt(addressAutocompleteSettings.min_length, 10),
        mode: addressAutocompleteSettings.managed_fields_display,
        removeDuplicates: addressAutocompleteSettings.remove_duplicates,
      };

      // If current language is available is Drupal settings path, use it !
      if (
        typeof settings.path.currentLanguage !== "undefined" &&
        parseInt(settings.path.currentLanguage, 10)
      ) {
        autocompleteSettings.lang = settings.path.currentLanguage;
      }

      // Initialize address autocomplete plugin.
      $(once("addressAutocompletePhoton", ".address-autocomplete-input", context))
        .addressAutocompletePhoton(autocompleteSettings);
    }
  };
})(jQuery, Drupal, once);
