<?php

namespace Drupal\address_static_map\Service;

use Drupal\key\KeyRepositoryInterface;

/**
 * Defines a MapSigner class to generate a signature for Google maps.
 */
class MapSigner {

  /**
   * The key repository service.
   *
   * @var \Drupal\key\KeyRepositoryInterface
   */
  protected $keyRepository;

  /**
   * Construct a MapSigner object.
   *
   * @param \Drupal\key\KeyRepositoryInterface $key_repository
   *   The key repository service.
   */
  public function __construct(KeyRepositoryInterface $key_repository) {
    $this->keyRepository = $key_repository;
  }

  /**
   * Returns the signature to get the Google Map.
   *
   * @param $key_id
   *   The id of the selected key for secret or premium crypto key.
   * @param $data
   *   The static map URL relative path.
   *
   * @return string
   *   The generated signature.
   */
  public function generateSignature($key_id, $data): string {
    if (!empty($key_id)) {
      $key = $this->keyRepository->getKey($key_id);
      if ($key && $key->getKeyValue()) {
        $signature = hash_hmac('sha1', $data, base64_decode(strtr($key->getKeyValue(), '-_', '+/')), TRUE);
        return strtr(base64_encode($signature), '+/', '-_');
      }
    }

    return '';
  }
}
