<?php

namespace Drupal\address_tweak\Plugin\Field\FieldWidget;

use Drupal\address\Plugin\Field\FieldWidget\AddressDefaultWidget;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\field_ui\Form\FieldConfigEditForm;

/**
 * Plugin implementation of the 'address_default' widget.
 *
 * @FieldWidget(
 *   id = "address_default_tweak",
 *   label = @Translation("Address (tweaked)"),
 *   field_types = {
 *     "address"
 *   },
 * )
 */
class AddressTweakedWidget extends AddressDefaultWidget {

  public function massageFormValues(array $values, array $form, FormStateInterface $form_state) {
    $values = parent::massageFormValues($values, $form, $form_state);
    if (!$form_state->getFormObject() instanceof FieldConfigEditForm) {
      foreach ($values as $delta => $valuekeys) {
        $keep = FALSE;
        foreach ($valuekeys as $key => $value) {
          if ($key !== 'country_code' && !empty($value)) {
            $keep = TRUE;
            break;
          }
        }
        if ($keep === FALSE) {
          unset($values[$delta]);
        }
      }
    }
    return $values;
  }

  public function formElement(FieldItemListInterface $items, $delta, array $element, array &$form, FormStateInterface $form_state) {
    $element = parent::formElement($items, $delta, $element, $form, $form_state);
    if (empty($element['address']['#default_value']['country_code']) && !$form_state->getFormObject() instanceof FieldConfigEditForm) {
      $element['address']['#default_value']['country_code'] = $items->getFieldDefinition()->getDefaultValueLiteral()[$delta]['country_code'] ?? null;
    }
    return $element;
  }
}
