## Admin feedback

### Setup / Installation
1. Download and install the module as usual.
2. Add the feedback block (Admin Feedback Block) to the block layout.
3. Navigate to /admin/feedback to see the dashboard.

### Overriding javascript-created html

There are several places where the module uses javascript to insert html into
the DOM:

- the feedback cancel button (`.feedback-btn__cancel`),
- the feedback status messages (`h2`),
- the feedback progress bar (`.admin_feedback__progress_bar`)

All of these are created using [`Drupal.theme()` functions](https://www.drupal.org/docs/drupal-apis/javascript-api/theming-in-javascript),
and may be overridden by themes.

#### Example: overriding feedback status messages in a theme

In the current theme, create a new library consisting of an entry in the theme's
libraries file, and a javascript file:

**Add to theme's libraries file, `themename.libraries.yml`**:

```yaml
admin_feedback_status:
  js:
    js/admin_feedback_status.js: {}
```

**Create a file in the theme directory at `js/admin_feedback_status.js`**:

```js
/**
 * @file
 * js/admin_feedback_status.js: overrides admin_feedback module's status markup.
 */
(function (Drupal) {
  /**
   * Implements Drupal.theme.adminFeedBackStatus().
   *
   * - changes status element from h2 to div.admin-feedback__status
   * - does not render statusDetails paragraph when statusDetails is empty 
   *
   * @param {string} status
   *   The main status message.
   * @param {string} statusDetails
   *   Further details for use when supplied.
   * @return string
   *   The status markup.
   */
  Drupal.theme.adminFeedbackStatus = function(status, statusDetails = null) {
    return `
      <div class="admin-feedback__status" role="status">${status}</div>
      ${statusDetails ? '<p>' + statusDetails + '</p>' : ''} 
    `;  
  }
})(Drupal);
```

### Any issues?
Please feel free to use the [Drupal.org Issue Queue for the module](https://www.drupal.org/project/issues/admin_feedback).
