<?php

declare(strict_types=1);

namespace Drupal\admin_toolbar_messages\Plugin\TopBarItem;

use Drupal\admin_toolbar_messages\AdminToolbarMessagesBuilder;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Drupal\Core\Routing\AdminContext;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\navigation\Attribute\TopBarItem;
use Drupal\navigation\TopBarItemBase;
use Drupal\navigation\TopBarRegion;
use Symfony\Component\DependencyInjection\ContainerInterface;

#[TopBarItem(
  id: 'admin_toolbar_messages',
  region: TopBarRegion::Actions,
  label: new TranslatableMarkup('Administrative Status Messages'),
)]
final class AdminMessagesTopBarItem extends TopBarItemBase implements ContainerFactoryPluginInterface {

  public function __construct(
    array $configuration,
    $plugin_id,
    $plugin_definition,
    private readonly AdminContext $adminContext,
  ) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition): self {
    return new self(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('router.admin_context'),
    );
  }

  public function build(): array {
    if ($this->adminContext->isAdminRoute()) {
      return [];
    }

    $build['admin_toolbar_messages'] = [
      'messages' => [
        '#lazy_builder' => [AdminToolbarMessagesBuilder::class . '::build', []],
        '#create_placeholder' => TRUE,
      ],
      '#attached' => [
        'library' => [
          'admin_toolbar_messages/navigation',
        ],
      ],
      '#weight' => 1100,
    ];

    return $build;
  }

}
