// 3 variables to say if this module requires consent before showing any ads
// Is consent via EU Cookie Compiance required?
var requireEUCC = drupalSettings.adsenseConsent.applyConsentPrefs.eu;
// Is consent via AdSense Consent required?
var requireAdSC = drupalSettings.adsenseConsent.applyConsentPrefs.ac;
// Is consent via Klaro required?
var requireKlaro = drupalSettings.adsenseConsent.applyConsentPrefs.klaro;


// Names of cookies used to set that consent
// The name of the cookie set by EU Cookie Compliance
var adConsentEuCookie = drupalSettings.adsenseConsent.applyConsentPrefs.eu_cookie;
// The name of the cookie set by AdSense Consent
var adConsentAcCookie = drupalSettings.adsenseConsent.applyConsentPrefs.ac_cookie;
// The name of the cookie set by Klaro
var klaroCookie = drupalSettings.adsenseConsent.applyConsentPrefs.klaro_cookie;
// The machine name of the service entity used by Klaro to give consent
var klaroEntityName = drupalSettings.adsenseConsent.applyConsentPrefs.klaro_service;

// Find the values of each of those cookies, if set
var allCookies = decodeURIComponent(document.cookie).split(";");
var adConsentEuCookieValue = "";
var adConsentAcCookieValue = "";
var klaroCookieValue = "";
for (var i=0; i < allCookies.length; i++)
{
  var cookie = allCookies[i];
  while (cookie.charAt(0) == " ") {
    cookie = cookie.substring(1);
  }
  if (cookie.indexOf(adConsentEuCookie + "=") == 0) {
    adConsentEuCookieValue = cookie.substring(adConsentEuCookie.length + 1, cookie.length);
  }
  if (cookie.indexOf(adConsentAcCookie + "=") == 0) {
    adConsentAcCookieValue = cookie.substring(adConsentAcCookie.length + 1, cookie.length);
  }
  if (cookie.indexOf(klaroCookie + "=") == 0) {
    klaroCookieValue = cookie.substring(klaroCookie.length + 1, cookie.length);
  }
}
var klaroConsent = klaroCookieValue.indexOf('"' + klaroEntityName + '":true') > 01;
var euccConsent = adConsentEuCookieValue == "1" || adConsentEuCookieValue == "2";
var adSCConsent = adConsentAcCookieValue == "1";
if (!requireEUCC && !requireAdSC && !requireKlaro) {
  // If no consents are required, we always show ads
  var adsenseConsent = true;
}
else {
  // If consent is required, we need consent from one of the chosen methods.
  // Start with the assumption we don't have consent
  var adsenseConsent = false;
  // Now check each possible consent method in turn. Is consent enabled and given?
  if (requireEUCC && euccConsent) {
    var adsenseConsent = true;
  }
  if (requireAdSC && adSCConsent) {
    var adsenseConsent = true;
  }
  if (requireKlaro && klaroConsent) {
    var adsenseConsent = true;
  }
}
