<?php

namespace Drupal\adva\Batch;

use Drupal\adva\Plugin\adva\OverridingAccessConsumerInterface;
use Drupal\Core\Entity\EntityTypeInterface;

interface ConsumerAccessRebuildBatchInterface {

  /**
   * The number of queued access records to rebuild in each batch.
   *
   * @var string
   */
  public const REBUILD_ACCESS_RECORDS_LIMIT = 20;

  /**
   * Batches all queued access records for the entity type.
   */
  public function createBatch(OverridingAccessConsumerInterface $access_consumer);

  /**
   * Processes batched rebuild access records operations for the entity type.
   *
   * @param \Drupal\Core\Entity\EntityTypeInterface $entity_type
   *   The entity type to process batch operations for.
   * @param array|\Traversable $context
   *   An array or traversable object of contextual key/value information for
   *   rebuild batch process.
   */
  public function process(EntityTypeInterface $entity_type, &$context);

  /**
   * Processes finished 'rebuild access record' batches.
   */
  public function finished($success, $results, $operations);

}
