<?php

namespace Drupal\adva\Plugin\Derivative;

use Drupal\adva\Plugin\adva\Manager\AccessConsumerManagerInterface;
use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides rebuild access record queues for entity types.
 */
class RebuildAccessRecordsDeriver extends DeriverBase implements ContainerDeriverInterface {

  /**
   * The Consumer Manager service.
   *
   * @var \Drupal\adva\Plugin\adva\Manager\AccessConsumerManagerInterface
   */
  protected $consumerManager;

  /**
   * Constructs new RebuildAccessRecords.
   *
   * @param string $base_plugin_id
   *   The base plugin ID for the plugin ID.
   * @param \Drupal\adva\Plugin\adva\Manager\AccessConsumerManagerInterface $consumer_manager
   *   The Consumer Manager service.
   */
  public function __construct($base_plugin_id, AccessConsumerManagerInterface $consumer_manager) {
    $this->consumerManager = $consumer_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id) {
    return new static(
      $base_plugin_id,
      $container->get('plugin.manager.adva.consumer')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition) {
    $derivatives = [];

    // Create a derivative for each entity type that has a consumer.
    foreach ($this->consumerManager->getOverrideConsumers() as $consumer) {
      $entity_type_id = $consumer->getEntityTypeId();

      $derivatives[$entity_type_id] = $base_plugin_definition;
    }

    return $derivatives;
  }

}
