<?php

namespace Drupal\adva\Plugin\adva;

use Drupal\Core\Form\FormStateInterface;

/**
 * Extends the AccessProvider definition to provide a bundle api system.
 */
interface EntityTypeAccessProviderInterface extends AccessProviderInterface {

  /**
   * Construct the configuration form for an operation.
   *
   * The passed form is a sub from that will be part of the form generated by
   * buildConfigForm().
   *
   * @param array $form
   *   Form render array for the root of the operations form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   Form state data for the operation config sub form.
   *
   * @return array
   *   The Form structure.
   */
  public function buildOperationConfigForm(array $form, FormStateInterface $form_state);

  /**
   * Handle form validation for the configuration form for an operation.
   *
   * The passed form is a sub from that will be part of the form being validated
   * in validateConfigForm().
   *
   * @param array $form
   *   Form render array for the root of the operations form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   Form state data for the operation config sub form.
   */
  public function validateOperationConfigForm(array $form, FormStateInterface $form_state);

  /**
   * Handle form submission for the configuration form for an operation.
   *
   * The passed form is a sub from that will be part of the form being submitted
   * in submitConfigForm().
   *
   * @param array $form
   *   Form render array for the root of the operations form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   Form state data for the operation config sub form.
   */
  public function submitOperationConfigForm(array $form, FormStateInterface $form_state);

  /**
   * Given a config array for an type, build access records.
   *
   * @param array $config
   *   Provider configuration a type or bundle.
   *
   * @return array
   *   Access records for the given entity type.
   */
  public function getAccessRecordsFromConfig(array $config);

  /**
   * Get the access records for a non bundled entity type.
   *
   * The result of this function will be cached by getAccessRecords(), and thus
   * only called once.
   *
   * @return array
   *   Access records for the given entity type.
   */
  public function getEntityTypeAccessRecords();

  /**
   * Get the default access records for a bundled entity type.
   *
   * The result of this function will be cached by getAccessRecords(), and thus
   * only called once.
   *
   * @return array
   *   Access records for the given entity type.
   */
  public function getEntityDefaultAccessRecords();

  /**
   * Get the access records for a given bundle.
   *
   * The result of this function will be cached by getAccessRecords(), and thus
   * only called once.
   *
   * @param string $bundle_name
   *   Bundle name of the bundle which access records are being generated for.
   *
   * @return array
   *   Access records for the given entity type.
   */
  public function getEntityBundleAccessRecords($bundle_name);

}
