<?php

namespace Drupal\adva\Plugin\adva;

use Drupal\Core\Entity\EntityTypeInterface;

/**
 * Defines access OverridingAccessConsumerInterface.
 *
 * Defines interface for extending upon the AccessConsumer to define the need
 * for overriding the access control handler class for an entity type and to
 * carryout the required modifications to the entity type info.
 *
 * @see adva_entity_type_build().
 */
interface OverridingAccessConsumerInterface extends AccessConsumerInterface {

  /**
   * Modify Entity Type definition to apply access control override.
   *
   * @param \Drupal\Core\Entity\EntityTypeInterface $entityType
   *   Entity type definition.
   */
  public function overrideAccessControlHandler(EntityTypeInterface $entityType);

  /**
   * Determines if a rebuild is required or not.
   *
   * @return bool
   *   Returns TRUE if the entity type has items in its queue, otherwise FALSE.
   */
  public function rebuildRequired();

  /**
   * Queues the rebuilding of access records for the entity type.
   *
   * @param array|null $entity_ids
   *   An optional array of entity ids to queue. If not provided, all entities
   *   will be queued.
   */
  public function queue(?array $entity_ids = NULL);


}
