<?php

declare(strict_types=1);

namespace Drupal\Tests\advance_script_manager\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Verifies admin access and UI links for Advance Script Manager.
 *
 * @group advance_script_manager
 */
class AdminAccessTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['advance_script_manager', 'node'];

  /**
   * Non-privileged user.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $basicUser;

  /**
   * Privileged admin user.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->basicUser = $this->drupalCreateUser(['access content']);
    $this->adminUser = $this->drupalCreateUser([
      'access content',
      'advance_script_manager_settings',
    ]);
  }

  /**
   * Tests access control and presence of UI action links.
   */
  public function testAdminAccessAndUi(): void {
    $route = '/admin/config/development/advance-script-manager';

    // Basic user should get 403.
    $this->drupalLogin($this->basicUser);
    $this->drupalGet($route);
    $this->assertSession()->statusCodeEquals(403);

    // Admin user should get 200 and can access add form route.
    $this->drupalLogin($this->adminUser);
    $this->drupalGet($route);
    $this->assertSession()->statusCodeEquals(200);
    // Verify add form route is accessible.
    $this->drupalGet('/admin/config/development/advance-script-manager/scripts');
    $this->assertSession()->statusCodeEquals(200);
  }

}


