<?php

declare(strict_types=1);

namespace Drupal\Tests\advance_script_manager\Functional;

use Drupal\Tests\BrowserTestBase;

/**
 * Tests that configured scripts are injected on matching pages.
 *
 * @group advance_script_manager
 */
class ScriptInjectionTest extends BrowserTestBase {

  /**
   * {@inheritdoc}
   */
  protected $defaultTheme = 'stark';

  /**
   * {@inheritdoc}
   */
  protected static $modules = ['advance_script_manager', 'node'];

  /**
   * Admin user for configuring scripts.
   *
   * @var \Drupal\user\UserInterface
   */
  protected $adminUser;

  /**
   * {@inheritdoc}
   */
  protected function setUp(): void {
    parent::setUp();
    $this->adminUser = $this->drupalCreateUser([
      'access content',
      'advance_script_manager_settings',
    ]);
    $this->drupalLogin($this->adminUser);
  }

  /**
   * Inserts a script and verifies it appears in the admin listing.
   */
  public function testScriptCreationAndListing(): void {
    // Insert directly into DB to avoid brittle UI dependencies.
    \Drupal::database()->insert('advance_script_manager')
      ->fields([
        'script_name' => 'Test header script',
        'script_code' => '<script data-test="asm-header">console.log("asm");</script>',
        'css_code' => '',
        'visibility_section' => 'Body',
        'pages_settings' => 'only',
        'visibility_pages' => '<front>',
        'content_type' => '',
        'user_roles' => '',
        'created' => \Drupal::time()->getRequestTime(),
        'updated' => \Drupal::time()->getRequestTime(),
        'status' => 1,
        'weight' => 0,
      ])
      ->execute();

    // Visit the manage scripts listing and assert the row appears.
    $this->drupalGet('/admin/config/development/advance-script-manager/manage-scripts');
    $this->assertSession()->statusCodeEquals(200);
    $this->assertSession()->pageTextContains('Test header script');
    $this->assertSession()->pageTextContains('Body');
  }

}


