Flexible 403 Redirect
 
Overview

The Flexible 403 Redirect module allows site administrators to customize
the redirection behavior when users attempt to access unpublished content. 
Instead of the default Drupal behavior, which redirects users to the access 
denied page, this module provides options to redirect users to a custom page,
such as a listing page, homepage, or any other specified URL. Additionally, 
administrators can display custom messages upon redirection.

Features

Configure custom redirect destinations for unpublished content.

Set different redirects based on content type or user roles.

Option to display a message after redirection.

Seamless integration with Drupal's existing configuration system.

Installation

Download and extract the module into your modules/custom directory.

Enable the module via the Extend page (/admin/modules) or using Drush:

drush en flexible_403_redirect -y

Clear the cache:

drush cr

Configuration

Navigate to Configuration → Flexible 403 Redirect Settings 
(/admin/config/system/flexible-403-redirect).

Select the redirect destination (homepage, listing page, or a custom URL).

Optionally, enter a message to display after redirection.

Save the configuration.

Usage

Once configured, when a user tries to access unpublished content:

Instead of seeing the default Access Denied page, they will be redirected 
based on the admin settings.

If a message is configured, it will be displayed after redirection.

Requirements

Drupal 9, 10, or 11.

No additional dependencies required.

Support & Contribution

If you find any issues or have feature requests, please open an 
issue in the module's repository.

Contributions are welcome! Feel free to submit pull requests or patches.

License

This module is open-source and distributed under the GNU General 
Public License v2.0 or later.

Maintainer: Harpreet Singh Saluja Drupal.org Profile:
https://www.drupal.org/u/harpreet_singh_saluja
