<?php

namespace Drupal\advanced_403_redirect;

use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityListBuilder;

/**
 * Provides a list controller for the access denied url entity type.
 */
class AccessDeniedUrlListBuilder extends EntityListBuilder {

  /**
   * {@inheritdoc}
   *
   * @return array
   *   A render array representing the list.
   */
  public function render() {
    $build['table'] = parent::render();

    $total = $this->getStorage()
      ->getQuery()
      ->accessCheck(FALSE)
      ->count()
      ->execute();

    $build['summary']['#markup'] = $this->t(
          'Total access 
        denied urls: @total', ['@total' => $total]
      );
    return $build;
  }

  /**
   * {@inheritdoc}
   *
   * @return array
   *   An associative array containing header labels.
   */
  public function buildHeader() {
    $header['id'] = $this->t('ID');
    $header['label'] = $this->t('Label');

    return $header + parent::buildHeader();
  }

  /**
   * {@inheritdoc}
   *
   * @param \Drupal\Core\Entity\EntityInterface $entity
   *   The entity to build a row for.
   *
   * @return array
   *   An associative array representing a row in the table.
   */
  public function buildRow(EntityInterface $entity) {
    /**
* @var \Drupal\advanced_403_redirect\AccessDeniedUrlInterface $entity
*/
    $row['id'] = $entity->id();
    $row['label'] = $entity->toLink();

    return $row + parent::buildRow($entity);
  }

}
