<?php

namespace Drupal\advanced_403_redirect\EventSubscriber;

use Drupal\Core\EventSubscriber\HttpExceptionSubscriberBase;
use Drupal\Core\Messenger\MessengerInterface;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpKernel\Event\ExceptionEvent;

/**
 * Redirect event subscriber.
 */
class AccessDeniedRedirectSubscriber extends HttpExceptionSubscriberBase {

  /**
   * The messenger.
   *
   * @var \Drupal\Core\Messenger\MessengerInterface
   */
  protected $messenger;

  /**
   * Constructs event subscriber.
   *
   * @param \Drupal\Core\Messenger\MessengerInterface $messenger
   *   The messenger.
   */
  public function __construct(MessengerInterface $messenger) {
    $this->messenger = $messenger;
  }

  /**
   * {@inheritdoc}
   */
  protected function getHandledFormats() {
    return ['html'];
  }

  /**
   * Redirects on 403 Access Denied kernel exceptions.
   *
   * @param \Symfony\Component\HttpKernel\Event\ExceptionEvent $event
   *   The Event to process.
   */
  public function on403(ExceptionEvent $event)
  {
    $current_user = \Drupal::currentUser();
    if (!in_array('administrator', $current_user->getRoles())) {
      $request = $event->getRequest();
      $current_user = \Drupal::currentUser();
      $current_path = $request->getPathInfo();

      $query = \Drupal::database()->select('access_denied_url', 'adu');
      $query->fields('adu', ['description', 'message']);
      $query->condition('label', $current_path);
      $result = $query->execute()->fetchAssoc();

      if ($result) {
        $destination_url = $result['description'];
        $status_message = $result['message'];

        if (!empty($status_message)) {
          $this->messenger->addMessage($status_message, 'warning');
        }

        // Perform the redirection.
        $response = new RedirectResponse($destination_url);
        $event->setResponse($response);
      }

    }
  }

}
