<?php

namespace Drupal\advanced_403_redirect\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Constraint for validating source and destination URLs.
 *
 * @Constraint(
 *   id = "DestinationValidation",
 *   label = @Translation("Source Destination Validation", context = "Validation"),
 *   type = "string"
 * )
 */
class DestinationValidationConstraint extends Constraint {
  /**
   * Error message for invalid routes.
   *
   * @var string
   */
  public $invalidRouteMessage = "The URL '@url' does not point to valid route";
  /**
   * Error message for invalid URL syntax.
   *
   * @var string
   */
  public $invalidUrlSyntax = "The URL '@url' should start with /";

}
