<?php

namespace Drupal\advanced_403_redirect\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;
use Symfony\Component\Validator\ConstraintValidator;

/**
 * Checks if source URL is unpublished and destination URL is published.
 */
class DestinationValidationConstraintValidator extends ConstraintValidator {

  /**
   * Validates the constraint.
   */
  public function validate($value, Constraint $constraint) {
    $entity = $value->getEntity();
    $destination_url = $entity->description->value;
    if (!str_starts_with($destination_url, '/')) {
      $this->context->addViolation(
            $constraint->invalidUrlSyntax,
            ['@url' => $destination_url]
        );
      return;
    }
    $router = \Drupal::service('router');
    try {
      $route_match = $router->match($destination_url);
      if ($route_match) {
        return TRUE;
      }
    }
    catch (\Exception $e) {
      $this->context->addViolation(
            $constraint->invalidRouteMessage,
            ['@url' => $destination_url]
        );
    }
  }

}
