<?php

namespace Drupal\advanced_403_redirect\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Constraint for validating source and destination URLs.
 *
 * @Constraint(
 *   id = "SourceValidation",
 *   label = @Translation("Source Destination Validation", context = "Validation"),
 *   type = "string"
 * )
 */
class SourceValidationConstraint extends Constraint {

  /**
   * Message shown when the source URL is not unpublished.
   *
   * @var string
   */
  public $sourceUnpublishedMessage = "The source URL '@url' must 
    be unpublished.";

  /**
   * Message shown when the URL doesn't point to a valid entity.
   *
   * @var string
   */
  public $invalidEntityMessage = "The URL '@url' does not point to 
    a valid entity.";

  /**
   * Message shown when the URL doesn't point to a valid route.
   *
   * @var string
   */
  public $invalidRouteMessage = "The URL '@url' does not point 
    to valid route";

  /**
   * Message shown when the URL syntax is invalid.
   *
   * @var string
   */
  public $invalidUrlSyntax = "The URL '@url' should start with /";

  /**
   * Message shown when the URL already exists.
   *
   * @var string
   */
  public $urlAlreadyExist = "The URL '@url' already exist";

}
