<?php

namespace Drupal\advanced_403_redirect\Entity;

use Drupal\advanced_403_redirect\AccessDeniedUrlInterface;
use Drupal\Core\Entity\ContentEntityBase;
use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Field\BaseFieldDefinition;

/**
 * Defines the access denied url entity class.
 *
 * @ContentEntityType(
 *   id = "access_denied_url",
 *   label = @Translation("Access denied Url"),
 *   label_collection = @Translation("Access denied Urls"),
 *   label_singular = @Translation("access denied url"),
 *   label_plural = @Translation("access denied urls"),
 *   label_count = @PluralTranslation(
 *     singular = "@count access denied urls",
 *     plural = "@count access denied urls",
 *   ),
 *   handlers = {
 *     "list_builder" = "Drupal\advanced_403_redirect\AccessDeniedUrlListBuilder",
 *     "views_data" = "Drupal\views\EntityViewsData",
 *     "form" = {
 *       "add" = "Drupal\advanced_403_redirect\Form\AccessDeniedUrlForm",
 *       "edit" = "Drupal\advanced_403_redirect\Form\AccessDeniedUrlForm",
 *       "delete" = "Drupal\Core\Entity\ContentEntityDeleteForm",
 *     },
 *     "route_provider" = {
 *       "html" = "Drupal\Core\Entity\Routing\AdminHtmlRouteProvider",
 *     }
 *   },
 *   base_table = "access_denied_url",
 *   admin_permission = "administer access denied url",
 *   entity_keys = {
 *     "id" = "id",
 *     "label" = "label",
 *     "uuid" = "uuid",
 *   },
 *   links = {
 *     "collection" = "/admin/content/access-denied-url",
 *     "add-form" = "/access-denied-url/add",
 *     "canonical" = "/access-denied-url/{access_denied_url}",
 *     "edit-form" = "/access-denied-url/{access_denied_url}/edit",
 *     "delete-form" = "/access-denied-url/{access_denied_url}/delete",
 *   },
 *   field_ui_base_route = "entity.access_denied_url.settings",
 * )
 */
class AccessDeniedUrl extends ContentEntityBase implements AccessDeniedUrlInterface {

  /**
   * {@inheritdoc}
   */
  public static function baseFieldDefinitions(EntityTypeInterface $entity_type) {

    $fields = parent::baseFieldDefinitions($entity_type);

    $fields['label'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Source Url'))
      ->setRequired(TRUE)
      ->setSetting('max_length', 255)
      ->setDisplayOptions(
              'form', [
                'type' => 'string_textfield',
                'weight' => -5,
              ]
          )
      ->addConstraint('SourceValidation')
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayOptions(
              'view', [
                'label' => 'hidden',
                'type' => 'string',
                'weight' => -5,
              ]
          )
      ->setDisplayConfigurable('view', TRUE);

    $fields['description'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Destination Url'))
      ->setRequired(TRUE)
      ->setDisplayOptions(
              'form', [
                'type' => 'string_textfield',
                'weight' => 4,
              ]
          )
      ->addConstraint('DestinationValidation')
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayOptions(
              'view', [
                'type' => 'text_default',
                'label' => 'above',
                'weight' => 10,
              ]
          )
      ->setDisplayConfigurable('view', TRUE);

    $fields['message'] = BaseFieldDefinition::create('string')
      ->setLabel(t('Display user redirect message'))
      ->setDisplayOptions(
              'form', [
                'type' => 'string_textfield',
                'weight' => 4,
              ]
          )
      ->setDisplayConfigurable('form', TRUE)
      ->setDisplayOptions(
              'view', [
                'type' => 'text_default',
                'label' => 'above',
                'weight' => 10,
              ]
          )
      ->setDisplayConfigurable('view', TRUE);

    return $fields;
  }

}
