<?php

namespace Drupal\advanced_403_redirect\Form;

use Drupal\Core\Entity\ContentEntityForm;
use Drupal\Core\Form\FormStateInterface;

/**
 * Form controller for the access denied url entity edit forms.
 */
class AccessDeniedUrlForm extends ContentEntityForm {

  /**
   * {@inheritdoc}
   */
  public function save(array $form, FormStateInterface $form_state) {
    $result = parent::save($form, $form_state);

    $entity = $this->getEntity();

    $message_arguments = ['%label' => $entity->toLink()->toString()];
    $logger_arguments = [
      '%label' => $entity->label(),
      'link' => $entity->toLink($this->t('View'))->toString(),
    ];

    switch ($result) {
      case SAVED_NEW:
        $this->messenger()->addStatus(
              $this->t(
                  'New access 
            denied url %label has been created.', $message_arguments
              )
          );
        $this->logger('advanced_403_redirect')->notice(
              'Created 
            new access denied url %label', $logger_arguments
          );
        break;

      case SAVED_UPDATED:
        $this->messenger()->addStatus(
              $this->t(
                  'The access 
            denied url %label has been updated.', $message_arguments
              )
          );
        $this->logger('advanced_403_redirect')->notice(
              'Updated 
            access denied url %label.', $logger_arguments
          );
        break;
    }

    $form_state->setRedirect('view.advanced_403_redirect.page_1');

    return $result;
  }

}
