<?php

namespace Drupal\advanced_403_redirect\Plugin\Validation\Constraint;

use Symfony\Component\Validator\Constraint;

/**
 * Constraint for validating source and destination URLs.
 *
 * @Constraint(
 *   id = "DestinationValidation",
 *   label = @Translation("Source Destination Validation", context = "Validation"),
 *   type = "string"
 * )
 */
class DestinationValidationConstraint extends Constraint {
  /**
   * Error message for invalid routes.
   *
   * @var string
   */
  public $invalidRouteMessage = "The URL '@url' does not point to a valid route.";

  /**
   * Error message for invalid URL syntax.
   *
   * @var string
   */
  public $invalidUrlSyntax = "The URL '@url' should start with a leading slash ('/').";

  /**
   * Return the service id of the validator to use for this constraint.
   *
   * This tells the validator system to use the service we registered in
   * advanced_403_redirect.services.yml.
   *
   * @return string
   *   The service id of the constraint validator.
   */
  public function validatedBy(): string {
    return 'advanced_403_redirect.destination_validator';
  }

}
