<?php

/**
 * @file
 * Bootstrap file for PHPUnit tests.
 */

use Composer\Autoload\ClassLoader;

// Find and load the Composer autoloader.
$autoloader = require __DIR__ . '/../../../../../vendor/autoload.php';

// Define DRUPAL_ROOT if not already defined.
if (!defined('DRUPAL_ROOT')) {
  define('DRUPAL_ROOT', realpath(__DIR__ . '/../../../../'));
}

// Register test namespaces.
$class_loader = new ClassLoader();
$class_loader->addPsr4('Drupal\\Tests\\', DRUPAL_ROOT . '/core/tests/Drupal/Tests');
$class_loader->addPsr4('Drupal\\TestTools\\', DRUPAL_ROOT . '/core/tests/Drupal/TestTools');
$class_loader->addPsr4('Drupal\\KernelTests\\', DRUPAL_ROOT . '/core/tests/Drupal/KernelTests');
$class_loader->addPsr4('Drupal\\FunctionalTests\\', DRUPAL_ROOT . '/core/tests/Drupal/FunctionalTests');

// Register the module's src directory.
$class_loader->addPsr4('Drupal\\advanced_country_field\\', __DIR__ . '/../src');

// Register the module's test namespaces.
$class_loader->addPsr4('Drupal\\Tests\\advanced_country_field\\', __DIR__ . '/src');

$class_loader->register();

