document.addEventListener('DOMContentLoaded', () => {
  const AHFP = document.querySelector('.advanced-header-field-preview');
  if (!AHFP) return;

  const ANCHOR_ID_BUTTON = AHFP.querySelector('button');
  if (!ANCHOR_ID_BUTTON) return;

  ANCHOR_ID_BUTTON.addEventListener('click', (e) => {
    e.preventDefault();

    const ANCHOR_ID = ANCHOR_ID_BUTTON.innerText;

    if (navigator.clipboard && window.isSecureContext) {
      navigator.clipboard.writeText(ANCHOR_ID);
    }
    else {
      alert(`Could not copy anchor id ("${ANCHOR_ID}") to clipboard.`);
    }
  });
});
