document.addEventListener('DOMContentLoaded', () => {
  const HEADERS = document.querySelectorAll('header[data-in-jump-menu]');
  if (!HEADERS.length) return;

  const JUMP_MENU = document.getElementById('jump-menu');
  if (!JUMP_MENU) return;

  const JUMP_MENU_CLASS = JUMP_MENU.getAttribute('class');

  const LIST = document.createElement('ul');
  LIST.classList.add(`${ JUMP_MENU_CLASS }__list`);

  HEADERS.forEach(header => {
    const HEADING = header.querySelector('h2, h3, h4, h5, h6');
    if (!HEADING) return;

    const LIST_ITEM = document.createElement('li');
    LIST_ITEM.classList.add(`${ JUMP_MENU_CLASS }__list-item`);

    const ANCHOR_LINK = document.createElement('a');
    ANCHOR_LINK.href = `#${ header.id }`;
    ANCHOR_LINK.textContent = header.getAttribute('data-short-title') || HEADING.textContent.trim();

    LIST_ITEM.appendChild(ANCHOR_LINK);
    LIST.appendChild(LIST_ITEM);
  });

  JUMP_MENU.appendChild(LIST);
});
