document.addEventListener('DOMContentLoaded', () => {
  const ADVANCED_HEADER_FIELDS = document.querySelectorAll('.advanced-header-field');
  if (!ADVANCED_HEADER_FIELDS.length) return;

  ADVANCED_HEADER_FIELDS.forEach(advancedHeaderField => {
    const ANCHOR_ID_BUTTON = advancedHeaderField.querySelector('button');
    if (!ANCHOR_ID_BUTTON) return;

    ANCHOR_ID_BUTTON.addEventListener('click', (e) => {
      e.preventDefault();

      const ANCHOR_ID = ANCHOR_ID_BUTTON.innerText;

      if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(ANCHOR_ID);
        alert('Anchor id copied to clipboard.');
      }
      else {
        alert(`Could not copy anchor id ("${ANCHOR_ID}") to clipboard.`);
      }
    });
  })
});
