<?php

namespace Drupal\advanced_header_field\Plugin\Field\FieldFormatter;

use Drupal\advanced_header_field\AdvancedHeaderFieldInterface;
use Drupal\Core\Field\FieldItemInterface;
use Drupal\Core\Field\FieldItemListInterface;
use Drupal\Core\Field\FormatterBase;

/**
 * Plugin implementation of the 'advanced_header_field' string formatter.
 *
 * @FieldFormatter(
 *   id = "advanced_header_field_string",
 *   label = @Translation("String (Admin Only)"),
 *   field_types = {
 *     "advanced_header_field"
 *   }
 * )
 */
class AdvancedHeaderFieldStringFormatter extends FormatterBase {

  /**
   * {@inheritdoc}
   */
  public function viewElements(FieldItemListInterface $items, $langcode) {
    $elements = [];

    foreach ($items as $delta => $item) {
      $elements[$delta] = $this->viewElement($item);
    }

    return $elements;
  }

  /**
   * {@inheritdoc}
   */
  protected function viewElement(FieldItemInterface $item) {
    $values = $item->getValue();

    if (!$values['title']) {
      return;
    }

    $options = $values['options'];

    $parent_id = AdvancedHeaderFieldInterface::getHeaderParentId($item);

    $element = [
      '#type' => 'inline_template',
      '#template' => '{{ heading_tag|upper }}: {{ heading_text }} (Anchor id: <button>{{ anchor_id }}</button>)',
      '#context' => [
        'heading_tag' => $options['heading_tag'],
        'heading_text' => $values['title'],
        'anchor_id' => !empty($options['custom_anchor_id']) ? $options['custom_anchor_id'] : AdvancedHeaderFieldInterface::createAnchorIdFromText($values['title'], $parent_id),
      ],
      '#prefix' => '<div class="advanced-header-field">',
      '#suffix' => '</div>',
    ];

    return $element;
  }

}
