<?php

namespace Drupal\advanced_header_field;

use Drupal\Core\Field\FieldItemInterface;

/**
 * Defines the interface for advanced header field.
 */
class AdvancedHeaderFieldInterface {

  // Define all the HTML tags that can be used.
  const AVAILABLE_TAGS = [
    'h2' => 'H2',
    'h3' => 'H3',
    'h4' => 'H4',
    'h5' => 'H5',
    'h6' => 'H6',
  ];

  // Define all the default sizes.
  const DEFAULT_SIZES = [
    'h1' => 'Heading 1',
    'h2' => 'Heading 2',
    'h3' => 'Heading 3',
    'h4' => 'Heading 4',
    'h5' => 'Heading 5',
    'h6' => 'Heading 6',
  ];

  // Define all default styles.
  const DEFAULT_STYLES = [
    'centered' => 'Centered',
  ];

  /**
   * Traverse upward to get the parent id.
   *
   * @param Drupal\Core\Field\FieldItemInterface $field_item
   *   The header field item.
   *
   * @return int|void
   *   The id of the parent entity.
   */
  public static function getHeaderParentId(FieldItemInterface $field_item) {
    /** @var Drupal\Core\Field\FieldItemList $field_item_list */
    $field_item_list = $field_item->getParent();

    /** @var Drupal\Core\Entity\Plugin\DataType\EntityAdapter $entity_adapter */
    $entity_adapter = $field_item_list?->getParent();

    /** @var Drupal\Core\Entity\EntityInterface $entity */
    $entity = $entity_adapter?->getEntity();

    return $entity->id();
  }

  /**
   * Create an anchor id from both $text and $id.
   *
   * @param string $text
   *   The text of the heading.
   * @param int|null $id
   *   The parent entity's id.
   *
   * @return string
   *   The complete anchor id from text and id.
   */
  public static function createAnchorIdFromText($text, $id) {
    if (empty($id)) {
      return '';
    }

    return str_replace(' ', '-', strtolower($text)) . '-' . $id;
  }

}
