document.addEventListener('DOMContentLoaded', () => {
  const ANCHOR_ID_BUTTONS = document.querySelectorAll('button[id^="anchor-id"]');
  if (!ANCHOR_ID_BUTTONS.length) return;

  ANCHOR_ID_BUTTONS.forEach(anchorIdButton => {
    anchorIdButton.addEventListener('click', (e) => {
      e.preventDefault();
      const ANCHOR_ID = anchorIdButton.innerText;

      if (navigator.clipboard && window.isSecureContext) {
        navigator.clipboard.writeText(ANCHOR_ID);
        alert(`Anchor id "${ANCHOR_ID}" copied to clipboard.`);
      }
      else {
        alert(`Could not copy anchor id "${ANCHOR_ID}" to clipboard.`);
      }
    });
  });
});
